(function () {
  if (typeof AH_FONT_RESIZER === 'undefined') return;

  const { selectors, scales, storageKey } = AH_FONT_RESIZER;

  // Choose a content element we can control
  function findTargets() {
  const targets = [];
  const wrapper = document.getElementById('ah-post-content');
  if (wrapper) targets.push(wrapper);

  // Optional: also set it on entry-content if present (harmless duplicate)
  document.querySelectorAll('.entry-content, .post-content').forEach(el => {
    if (!targets.includes(el)) targets.push(el);
  });

  // As a final fallback, honor any selectors from PHP
  if (typeof AH_FONT_RESIZER !== 'undefined' && Array.isArray(AH_FONT_RESIZER.selectors)) {
    AH_FONT_RESIZER.selectors.forEach(sel => {
      document.querySelectorAll(sel).forEach(el => {
        if (!targets.includes(el)) targets.push(el);
      });
    });
  }
  return targets;
}


  // State
  const SCALE_MAP = {
    normal: parseFloat(scales.normal || '1.0'),
    large:  parseFloat(scales.large  || '1.125'),
    xlarge: parseFloat(scales.xlarge || '1.25')
  };

  const saved = window.localStorage.getItem(storageKey);
  let currentKey = (saved && SCALE_MAP[saved]) ? saved : 'normal';

  function applyScale(key) {
  const scale = SCALE_MAP[key] || SCALE_MAP.normal;
  const targets = findTargets();
  if (targets.length) {
    targets.forEach(t => t.style.setProperty('--ah-scale', String(scale)));
  }

  document.querySelectorAll('.ah-fr-btn').forEach(btn => {
    const isActive = (btn.getAttribute('data-ah-scale') === key);
    btn.setAttribute('aria-pressed', isActive ? 'true' : 'false');
  });

  currentKey = key;
  try { localStorage.setItem(storageKey, key); } catch (_) {}
}

  // Event delegation for any widgets present
  function bindEvents() {
    document.addEventListener('click', function (e) {
      const btn = e.target.closest('.ah-fr-btn');
      if (!btn) return;
      const key = btn.getAttribute('data-ah-scale');
      if (!key) return;
      e.preventDefault();
      applyScale(key);
    });

    // Keyboard: left/right to switch within toolbar
    document.querySelectorAll('.ah-fr-toolbar').forEach(tb => {
      tb.addEventListener('keydown', function (e) {
        const buttons = Array.from(tb.querySelectorAll('.ah-fr-btn'));
        const idx = buttons.indexOf(document.activeElement);
        if (idx === -1) return;

        if (e.key === 'ArrowRight') {
          e.preventDefault();
          const next = buttons[Math.min(idx + 1, buttons.length - 1)];
          next.focus();
        } else if (e.key === 'ArrowLeft') {
          e.preventDefault();
          const prev = buttons[Math.max(idx - 1, 0)];
          prev.focus();
        }
      });
    });
  }

  // Init on DOM ready
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }

  function init() {
    bindEvents();
    applyScale(currentKey);
  }
})();
